/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.curses;

import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Normality
extends AbstractCard {
    public static final String ID = "Normality";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Normality");
    public static final String NAME = Normality.cardStrings.NAME;
    public static final String DESCRIPTION = Normality.cardStrings.DESCRIPTION;
    public static final String[] EXTENDED_DESCRIPTION = Normality.cardStrings.EXTENDED_DESCRIPTION;
    private static final int COST = -2;
    private static final int POOL = 2;
    private static final int PLAY_LIMIT = 3;

    public Normality() {
        super(ID, NAME, "curse/normality", "curse/normality", -2, DESCRIPTION, AbstractCard.CardType.CURSE, AbstractCard.CardColor.CURSE, AbstractCard.CardRarity.CURSE, AbstractCard.CardTarget.NONE, 2);
    }

    @Override
    public boolean canPlay(AbstractCard card) {
        if (AbstractDungeon.player.cardsPlayedThisTurn >= 3) {
            card.cantUseMessage = EXTENDED_DESCRIPTION[0];
            return false;
        }
        return true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (p.hasRelic("Blue Candle")) {
            this.useBlueCandle(p);
        } else {
            AbstractDungeon.actionManager.addToBottom(new UseCardAction(this));
        }
    }

    @Override
    public void applyPowers() {
        super.applyPowers();
        this.rawDescription = AbstractDungeon.player.cardsPlayedThisTurn == 0 ? EXTENDED_DESCRIPTION[1] + 3 + EXTENDED_DESCRIPTION[2] : (AbstractDungeon.player.cardsPlayedThisTurn == 1 ? EXTENDED_DESCRIPTION[1] + 3 + EXTENDED_DESCRIPTION[3] + AbstractDungeon.player.cardsPlayedThisTurn + EXTENDED_DESCRIPTION[4] : EXTENDED_DESCRIPTION[1] + 3 + EXTENDED_DESCRIPTION[3] + AbstractDungeon.player.cardsPlayedThisTurn + EXTENDED_DESCRIPTION[2]);
        this.initializeDescription();
    }

    @Override
    public AbstractCard makeCopy() {
        return new Normality();
    }

    @Override
    public void upgrade() {
    }
}

